/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CertificateItem
extends Item {
    private final boolean adoption;

    public CertificateItem(boolean adoption) {
        super(new Item.Properties());
        this.adoption = adoption;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof SimplyCatEntity || target instanceof Wolf || target instanceof Parrot) {
            TamableAnimal tameable = (TamableAnimal)target;
            if (this.adoption) {
                if (tameable instanceof SimplyCatEntity && ((SimplyCatEntity)tameable).canBeTamed(player) || !(tameable instanceof SimplyCatEntity) && !tameable.m_21824_()) {
                    if (tameable instanceof SimplyCatEntity) {
                        ((SimplyCatEntity)tameable).setTamed(true, player);
                    } else {
                        tameable.m_21828_(player);
                    }
                    tameable.m_21573_().m_26573_();
                    tameable.m_21839_(true);
                    tameable.m_21153_(tameable.m_21233_());
                    player.m_5661_((Component)Component.m_237110_((String)"chat.info.adopt_usage", (Object[])new Object[]{tameable.m_7755_()}), true);
                    if (player.m_9236_().f_46443_) {
                        this.playTameEffect(true, tameable.m_9236_(), tameable);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (tameable instanceof SimplyCatEntity && !tameable.m_21824_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"chat.info.tamed_limit_reached"), true);
                    return InteractionResult.PASS;
                }
            } else if (tameable.m_21830_((LivingEntity)player)) {
                if (tameable instanceof SimplyCatEntity) {
                    ((SimplyCatEntity)tameable).setTamed(false, player);
                } else {
                    tameable.m_7105_(false);
                }
                tameable.m_21573_().m_26573_();
                tameable.m_21816_(null);
                player.m_5661_((Component)Component.m_237110_((String)"chat.info.release_usage", (Object[])new Object[]{tameable.m_7755_()}), true);
                this.playTameEffect(false, tameable.m_9236_(), tameable);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void playTameEffect(boolean play, Level world, TamableAnimal entity) {
        SimpleParticleType iparticledata = ParticleTypes.f_123750_;
        if (!play) {
            iparticledata = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = world.f_46441_.m_188583_() * 0.02;
            double d1 = world.f_46441_.m_188583_() * 0.02;
            double d2 = world.f_46441_.m_188583_() * 0.02;
            world.m_7106_((ParticleOptions)iparticledata, entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)("tooltip.certificate_" + (this.adoption ? "adopt" : "release") + ".desc")));
    }
}

